﻿//////////////////////////////////////////////
// DummyEnvironmentStrategy.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkScripts
#include "EnvironmentStrategy.h"

/// Class ------------------------------------

namespace nkScripts
{
	class DummyEnvironmentStrategy final : public EnvironmentStrategy
	{
		public :

			// Constructeur, destructeur
			DummyEnvironmentStrategy (Environment* parentEnv) noexcept ;
			~DummyEnvironmentStrategy () ;

			// Exécution
			virtual bool execute (const Script& script) override ;
			virtual void requestGarbageCollection () override ;
			virtual void shutdown () override ;

			// Set mémoire env
			virtual void setVar (nkMemory::StringView name, bool value) override ;
			virtual void setVar (nkMemory::StringView name, int value) override ;
			virtual void setVar (nkMemory::StringView name, float value) override ;
			virtual void setVar (nkMemory::StringView name, double value) override ;
			virtual void setVar (nkMemory::StringView name, nkMemory::StringView value) override ;
			virtual void setVar (nkMemory::StringView name, const ScriptObjectReference& value) override ;
			virtual void setObject (nkMemory::StringView name, nkMemory::StringView userType, void* value) override ;

			virtual bool isSet (nkMemory::StringView name) override ;

			virtual bool getVar (nkMemory::StringView name, bool defaultValue) override ;
			virtual int getVar (nkMemory::StringView name, int defaultValue) override ;
			virtual float getVar (nkMemory::StringView name, float defaultValue) override ;
			virtual double getVar (nkMemory::StringView name, double defaultValue) override ;
			virtual nkMemory::StringView getVar (nkMemory::StringView name, nkMemory::StringView defaultValue) override ;
			virtual ScriptObjectReference getVar (nkMemory::StringView name) override ;
			virtual void* getObject (nkMemory::StringView name, nkMemory::StringView userType) override ;
			virtual ScriptObjectReference getScriptFunction (nkMemory::StringView name) override ;

			// Functions
			virtual Function* setFunc (nkMemory::StringView name) override ;

			// UserTypes
			virtual UserType* setUserType (nkMemory::StringView name) override ;

			// Namespaces
			virtual Namespace* setNamespace (nkMemory::StringView name) override ;

			// Call C++ -> Script
			virtual bool callScriptFunction (const ScriptObjectReference& reference, const DataStack& args, DataStack& expectedOutput) override ;
			virtual nkMemory::Buffer serializeScriptObject (const ScriptObjectReference& reference, bool forwardUserDataOwnership) override ;
			virtual ScriptObjectReference deserializeScriptObject (nkMemory::BufferView<unsigned char> object) override ;
	} ;
}